/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.SOAPMessageUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class VWXMLWrapper {
    private static Logger m_logger = Logger.getLogger("filenet.vw.base");
    private Document m_document = null;
    private Node m_rootNode = null;
    private StringBuffer m_xmlStringBuffer = new StringBuffer();
    private Hashtable m_namespaces = new Hashtable();

    public static String _get_FILE_DATE() {
        return "$Date:   13 Aug 2008 18:58:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    public VWXMLWrapper(String rootNodeName, String namespace) throws Exception {
        try {
            this.m_document = XMLHelper.newDocumentViaDOM();
            this.m_rootNode = this.m_document.createElement(rootNodeName);
            this.m_document.appendChild(this.m_rootNode);
            this.m_rootNode = this.m_document.getDocumentElement();
            this.setNodeAttribute(this.m_rootNode, "xmlns", namespace);
            this.m_rootNode.appendChild(this.m_document.createTextNode(""));
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWXMLWrapper::create exception.", ex);
            throw ex;
        }
    }

    public VWXMLWrapper(String documentStream) throws Exception {
        try {
            m_logger = Logger.getLogger("filenet.vw.base");
            this.m_document = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(documentStream)), null, null, false);
            this.m_rootNode = this.m_document.getDocumentElement();
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWXMLWrapper::parse exception.", ex);
            throw ex;
        }
    }

    public VWXMLWrapper(FileInputStream fileInputStream) throws Exception {
        this(fileInputStream, null);
    }

    public VWXMLWrapper(FileInputStream fileInputStream, EntityResolver resolver) throws Exception {
        try {
            m_logger = Logger.getLogger("filenet.vw.base");
            BufferedInputStream inputXML = new BufferedInputStream(fileInputStream);
            InputSource inSrc = new InputSource(inputXML);
            this.m_document = XMLHelper.parseDocumentViaDOM(inSrc, resolver, null, false);
            this.m_rootNode = this.m_document.getDocumentElement();
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWXMLWrapper::parse exception.", ex);
            throw ex;
        }
    }

    public VWXMLWrapper(InputSource inputSource, EntityResolver resolver) throws Exception {
        try {
            m_logger = Logger.getLogger("filenet.vw.base");
            this.m_document = XMLHelper.parseDocumentViaDOM(inputSource, resolver, null, false);
            this.m_rootNode = this.m_document.getDocumentElement();
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWXMLWrapper::parse exception.", ex);
            throw ex;
        }
    }

    public Node createNodeNamed(Node parentNode, String name, String value) {
        if (this.m_document == null || parentNode == null) {
            return null;
        }
        Element newNode = this.m_document.createElement(name);
        parentNode.appendChild(newNode);
        if (value != null && value.length() > 0) {
            newNode.appendChild(this.m_document.createTextNode(value));
        } else {
            newNode.appendChild(this.m_document.createTextNode(""));
        }
        return newNode;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public static Node getNodeNamed(Node parentNode, String name) {
        if (parentNode == null) {
            return null;
        }
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getLocalName();
                if (nodeName == null) {
                    nodeName = node.getNodeName();
                }
                if (name.compareTo(nodeName) != 0) continue;
                return node;
            }
        }
        return null;
    }

    public static Node[] getNodesNamed(Node parentNode, String name) {
        if (parentNode == null) {
            return null;
        }
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            Vector<Node> nodes = new Vector<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getLocalName();
                if (nodeName == null) {
                    nodeName = node.getNodeName();
                }
                if (name.compareTo(nodeName) != 0) continue;
                nodes.addElement(node);
            }
            if (nodes.size() > 0) {
                Object[] nodeArray = new Node[nodes.size()];
                nodes.copyInto(nodeArray);
                return nodeArray;
            }
        }
        return null;
    }

    public static String getNodeValue(Node parentNode, String name) {
        String newText;
        Node childNode;
        Node node = VWXMLWrapper.getNodeNamed(parentNode, name);
        if (node != null && (childNode = node.getFirstChild()) != null && (newText = childNode.getNodeValue().trim()) != null && newText.length() > 0) {
            return newText;
        }
        return null;
    }

    public Node getRootNode() {
        return this.m_rootNode;
    }

    public Node setNodeAttribute(Node node, String attrName, String attrValue) {
        if (this.m_document == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Attr attrNode = this.m_document.createAttribute(attrName);
            attrNode.setNodeValue(attrValue);
            attributes.setNamedItem(attrNode);
            return attrNode;
        }
        return null;
    }

    public boolean setNodeValue(Node parentNode, String name, String value) {
        if (this.m_document == null) {
            return false;
        }
        Node node = VWXMLWrapper.getNodeNamed(parentNode, name);
        if (node != null) {
            Node childNode = node.getFirstChild();
            if (childNode != null) {
                childNode.setNodeValue(value);
                return true;
            }
            if (value != null && value.length() > 0) {
                node.appendChild(this.m_document.createTextNode(value));
            } else {
                node.appendChild(this.m_document.createTextNode(""));
            }
            return true;
        }
        Node newNode = this.createNodeNamed(parentNode, name, value);
        return newNode != null;
    }

    public String toString() {
        return this.toXML(this.m_document);
    }

    public String toXML(Node node) {
        if (node == null) {
            return null;
        }
        this.m_xmlStringBuffer.setLength(0);
        this.m_namespaces.clear();
        this.createXMLStream(node);
        return this.m_xmlStringBuffer.toString();
    }

    public static void getAllNodesNamed(Node parentNode, String ns, String localName, Vector v) {
        if (parentNode == null) {
            return;
        }
        NodeList nodeList = parentNode.getChildNodes();
        int nItems = nodeList == null ? 0 : nodeList.getLength();
        for (int i = 0; i < nItems; ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getLocalName();
            if (nodeName == null) {
                nodeName = node.getNodeName();
            }
            if (localName.compareTo(nodeName) == 0 && (ns == null || ns.equals(node.getNamespaceURI()))) {
                v.addElement(node);
            }
            VWXMLWrapper.getAllNodesNamed(node, ns, localName, v);
        }
    }

    public static void getAllNodesNamedWithPartialNS(Node parentNode, String nsSubStr, String localName, Vector v) {
        if (parentNode == null) {
            return;
        }
        NodeList nodeList = parentNode.getChildNodes();
        int nItems = nodeList == null ? 0 : nodeList.getLength();
        for (int i = 0; i < nItems; ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getLocalName();
            if (nodeName == null) {
                nodeName = node.getNodeName();
            }
            String nodeNs = node.getNamespaceURI();
            if (localName.compareTo(nodeName) == 0 && (nsSubStr == null || nodeNs != null && nodeNs.indexOf(nsSubStr) == 0)) {
                v.addElement(node);
            }
            VWXMLWrapper.getAllNodesNamedWithPartialNS(node, nsSubStr, localName, v);
        }
    }

    public static String getNodeAttribute(Node n, String attrName) {
        if (n == null) {
            return null;
        }
        NamedNodeMap m = n.getAttributes();
        if (m == null) {
            return null;
        }
        Node n2 = m.getNamedItem(attrName);
        if (n2 == null) {
            return null;
        }
        return n2.getNodeValue();
    }

    public static void main(String[] args) {
        try {
            String m_inputMsg = "<Q1:in0 xmlns=\"urn:dirp2\" xmlns:Q1=\"urn:dipr\" xmlns:Q2=\"urn:dipr11\"><diprPayload xmlns=\"http://shared.axis.dipr.wfb.com\"><Q1:accountInfo><Q1:accountNumber>1234</Q1:accountNumber><companyNumber></companyNumber><hoganProductCode></hoganProductCode></Q1:accountInfo><formName></formName><image><fnpo:MIMEATT xmlns:fnpo=\"http://www.filenet.com/ns/fnpe/2004/12/po/schema/basic\" href=\"InvokeMultiplicationService||3|3|test2|{0617202A-0A0E-4474-96B7-5EF5995DBC2E}\"/></image><imageKey></imageKey><pageCount></pageCount></diprPayload><requiredRecordsManagementMetadata xmlns=\"http://shared.axis.dipr.wfb.com\"><Q2:RPONumber>XYZZZZZ</Q2:RPONumber><RPORelease></RPORelease><RPOReleasor></RPOReleasor><RPOReleasorDept></RPOReleasorDept><captureLocation></captureLocation><contributor></contributor><creationDate></creationDate><destroyedDate></destroyedDate><destructionDate></destructionDate><dispositionType></dispositionType><format></format><identifier></identifier><litigationLong></litigationLong><litigationShort></litigationShort><owner></owner><preservationDate></preservationDate><privilegedConfidential></privilegedConfidential><recordClassification></recordClassification><resourceType></resourceType><retentionPeriod></retentionPeriod><status></status><version></version><versionDate></versionDate></requiredRecordsManagementMetadata></Q1:in0>";
            String wrapperBegin = "<QTESTXXX xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
            String wrapperEnd = "</QTESTXXX>";
            StringBuffer buf = new StringBuffer("<QTESTXXX xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            buf.append(m_inputMsg);
            buf.append("</QTESTXXX>");
            String myStr = buf.toString();
            System.out.println("Original String = " + myStr);
            System.out.println("--------------");
            VWXMLWrapper myStrDoc = new VWXMLWrapper(myStr);
            String myStr2 = myStrDoc.toXML(myStrDoc.getRootNode());
            System.out.println("New String = " + myStr2);
            System.out.println("--------------");
            String myStr3 = SOAPMessageUtils.docToString(myStrDoc.getDocument());
            System.out.println("Using SOAPMEssageUtils.docToString String = " + myStr3);
            System.out.println("--------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createXMLStream(Node node) {
        if (node == null) {
            return;
        }
        short nNodeType = node.getNodeType();
        switch (nNodeType) {
            case 9: {
                this.m_xmlStringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.createXMLStream(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                NamedNodeMap attributes;
                boolean useDefaultNS = false;
                String nodeName = ((Element)node).getTagName();
                this.m_xmlStringBuffer.append("<");
                this.m_xmlStringBuffer.append(nodeName);
                String nsURI = node.getNamespaceURI();
                if (nsURI != null) {
                    String prefix = node.getPrefix();
                    if (prefix != null) {
                        String storedPrefix = (String)this.m_namespaces.get(nsURI);
                        if (storedPrefix == null || !storedPrefix.equals(prefix)) {
                            this.m_xmlStringBuffer.append(" xmlns:");
                            this.m_xmlStringBuffer.append(prefix);
                            this.m_xmlStringBuffer.append("=\"");
                            this.m_xmlStringBuffer.append(nsURI);
                            this.m_xmlStringBuffer.append("\"");
                            this.m_namespaces.put(nsURI, prefix);
                        }
                    } else {
                        useDefaultNS = true;
                    }
                }
                if ((attributes = node.getAttributes()) != null) {
                    for (int nIndex = 0; nIndex < attributes.getLength(); ++nIndex) {
                        String attrName = attributes.item(nIndex).getLocalName();
                        String attrPrefix = attributes.item(nIndex).getPrefix();
                        String attrValue = attributes.item(nIndex).getNodeValue();
                        boolean writeAttr = true;
                        if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                            String storedPrefix = (String)this.m_namespaces.get(attrValue);
                            if (storedPrefix != null && storedPrefix.equals(attrName)) {
                                writeAttr = false;
                            } else {
                                this.m_namespaces.put(attrValue, attrName);
                            }
                        }
                        if (!writeAttr) continue;
                        this.m_xmlStringBuffer.append(" ");
                        this.m_xmlStringBuffer.append(attributes.item(nIndex).getNodeName());
                        this.m_xmlStringBuffer.append("=\"");
                        this.m_xmlStringBuffer.append(XMLHelper.toXMLString(attrValue));
                        this.m_xmlStringBuffer.append("\"");
                    }
                }
                this.m_xmlStringBuffer.append(">");
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    for (int nIndex = 0; nIndex < childNodes.getLength(); ++nIndex) {
                        this.createXMLStream(childNodes.item(nIndex));
                    }
                }
                this.m_xmlStringBuffer.append("</");
                this.m_xmlStringBuffer.append(nodeName);
                this.m_xmlStringBuffer.append(">");
                break;
            }
            case 4: {
                this.m_xmlStringBuffer.append("<![CDATA[");
                this.m_xmlStringBuffer.append(node.getNodeValue());
                this.m_xmlStringBuffer.append("]]>");
                break;
            }
            case 3: {
                String value = node.getNodeValue().trim();
                if (value == null || value.length() <= 0) break;
                this.m_xmlStringBuffer.append(XMLHelper.toXMLString(value));
                break;
            }
            case 7: {
                this.m_xmlStringBuffer.append("<?");
                String value = node.getNodeValue();
                if (value != null && value.length() > 0) {
                    this.m_xmlStringBuffer.append(value);
                }
                this.m_xmlStringBuffer.append("?>");
                break;
            }
        }
    }
}

